/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.compat.jei;

import de.ellpeck.prettypipes.misc.ItemEquality;
import de.ellpeck.prettypipes.packets.PacketCraftingModuleTransfer;
import de.ellpeck.prettypipes.packets.PacketHandler;
import de.ellpeck.prettypipes.pipe.modules.craft.CraftingModuleContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;

public class CraftingModuleTransferHandler
implements IRecipeTransferHandler<CraftingModuleContainer, CraftingRecipe> {
    public Class<CraftingModuleContainer> getContainerClass() {
        return CraftingModuleContainer.class;
    }

    public Class<CraftingRecipe> getRecipeClass() {
        return CraftingRecipe.class;
    }

    public IRecipeTransferError transferRecipe(CraftingModuleContainer container, CraftingRecipe recipe, IRecipeLayout recipeLayout, Player player, boolean maxTransfer, boolean doTransfer) {
        if (!doTransfer) {
            return null;
        }
        Map ingredients = recipeLayout.getItemStacks().getGuiIngredients();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        for (Map.Entry entry : ingredients.entrySet()) {
            List allIngredients = ((IGuiIngredient)entry.getValue()).getAllIngredients();
            if (allIngredients.isEmpty()) continue;
            ItemStack remain = ((ItemStack)allIngredients.get(0)).m_41777_();
            ArrayList<ItemStack> toAdd = ((IGuiIngredient)entry.getValue()).isInput() ? inputs : outputs;
            for (ItemStack stack : toAdd) {
                if (!ItemEquality.compareItems(stack, remain, new ItemEquality[0])) continue;
                int fits = Math.min(stack.m_41741_() - stack.m_41613_(), remain.m_41613_());
                stack.m_41769_(fits);
                remain.m_41774_(fits);
                if (!remain.m_41619_()) continue;
                break;
            }
            if (remain.m_41619_()) continue;
            toAdd.add(remain);
        }
        PacketHandler.sendToServer(new PacketCraftingModuleTransfer(inputs, outputs));
        return null;
    }
}

